/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.blocks.metal.TurretBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TurretChemBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TurretGunBlockEntity;
import blusunrize.immersiveengineering.common.gui.IEBaseContainer;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.items.BulletItem;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class TurretContainer<T extends TurretBlockEntity<T>>
extends IEBaseContainer<T> {
    public TurretContainer(MenuType<?> type, int id, Inventory inventoryPlayer, T tile) {
        super(type, tile, id);
        int i;
        this.tile = tile;
        if (tile instanceof TurretGunBlockEntity) {
            TurretGunBlockEntity gunTurret = (TurretGunBlockEntity)tile;
            this.m_38897_((Slot)new IESlot.Bullet(gunTurret.containerHandler.get(), 0, 134, 13, 64){

                @Override
                public boolean m_5857_(ItemStack itemStack) {
                    if (!super.m_5857_(itemStack)) {
                        return false;
                    }
                    BulletHandler.IBullet bullet = ((BulletItem)itemStack.m_41720_()).getType();
                    return bullet != null && bullet.isValidForTurret();
                }
            });
            this.m_38897_(new IESlot.Output(this, this.inv, 1, 134, 49));
            this.slotCount = 2;
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 109 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 167));
        }
        this.addGenericData(GenericContainerData.energy(((TurretBlockEntity)tile).energyStorage));
    }

    public static class GunTurretContainer
    extends TurretContainer<TurretGunBlockEntity> {
        public GunTurretContainer(MenuType<?> type, int id, Inventory inventoryPlayer, TurretGunBlockEntity tile) {
            super(type, id, inventoryPlayer, tile);
            this.addGenericData(GenericContainerData.bool(() -> tile.expelCasings, b -> {
                tile.expelCasings = b;
            }));
        }
    }

    public static class ChemTurretContainer
    extends TurretContainer<TurretChemBlockEntity> {
        public ChemTurretContainer(MenuType<?> type, int id, Inventory inventoryPlayer, TurretChemBlockEntity tile) {
            super(type, id, inventoryPlayer, tile);
            this.addGenericData(GenericContainerData.fluid(tile.tank));
            this.addGenericData(GenericContainerData.bool(() -> tile.ignite, b -> {
                tile.ignite = b;
            }));
        }
    }
}

